#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_TestingWorklist : BaseTest 
	{

		private System.DateTime _startDate = System.DateTime.Now.AddYears(-5);
		private System.DateTime _endDate = System.DateTime.Now;

		private System.DateTime _invalidStart = System.DateTime.Now.AddYears(1);
		private System.DateTime _invalidEnd = System.DateTime.Now.AddYears(2);

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}

		[Test]
		public void GetTestingWorklistCount_Pass()
		{
			int listCount = 0; 
			
			listCount = DAL.TestingWorklist.GetTestingWorklistCount(this._startDate , this._endDate, true, true, true, true);

			Assert.AreEqual(true, listCount > 0, "Available Worklist count");
		}

		[Test]
		public void GetTestingWorklistCount_Fail()
		{
			int listCount = 0;
			
			listCount = DAL.TestingWorklist.GetTestingWorklistCount(this._startDate, this._endDate, false, false, false, false);
			Assert.AreEqual(0, listCount, "Available Worklist count");
		}

		[Test]
		public void GetPatientTestingWorklist_Date_Date_Pass()
		{
			DataTable dtTest = DAL.TestingWorklist.GetPatientTestingWorklist(this._startDate, this._endDate);
			
			Assert.AreEqual(40, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.TestingWorklistReportType), ARTIFICIAL.TestingWorklistReportType);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientGuid), TABLES.Patient.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientSpecimenGuid), TABLES.PatientSpecimen.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.TestGuid), ARTIFICIAL.TestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.TestUnitId), ARTIFICIAL.TestUnitId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ExceptionTransfusion.UnitId), TABLES.ExceptionTransfusion.UnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientLocation), TABLES.PatientTreatment.PatientLocation);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenAccessionNumber), TABLES.PatientSpecimen.SpecimenAccessionNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenCollectionDate), TABLES.PatientSpecimen.SpecimenCollectionDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.OrderableTestId), TABLES.BloodTestType.OrderableTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestText), TABLES.OrderableTest.OrderableTestText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestName), TABLES.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestingMethodCode), TABLES.SpecimenTest.TestingMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.TestingMethodText), TABLES.TestingMethod.TestingMethodText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackName), TABLES.Rack.RackName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.TestedWith), TABLES.BloodTestType.TestedWith);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.BloodTestTypeId), TABLES.SpecimenTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.Phase), TABLES.BloodTestType.Phase);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.SortColumn), TABLES.BloodTestType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestResultId), TABLES.SpecimenTest.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeName), TABLES.AntibodyType.AntibodyTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.TestTechId), TABLES.RackTest.TestTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestDate), TABLES.SpecimenTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.WorklistDate), ARTIFICIAL.WorklistDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestComments), TABLES.SpecimenTest.TestComments);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.AutoInstrumentName), TABLES.SpecimenTest.AutoInstrumentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.RecordStatusCode), TABLES.SpecimenTest.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.LastUpdateUser), TABLES.SpecimenTest.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.LastUpdateDate), TABLES.SpecimenTest.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.InactivateUser), TABLES.SpecimenTest.InactivateUser);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.InactivateDate), TABLES.SpecimenTest.InactivateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentText), TABLES.CannedComment.CannedCommentText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.CorrectedResultIndicator), TABLES.SpecimenTest.CorrectedResultIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.OffsiteIndicator), TABLES.SpecimenTest.OffsiteIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.OffsiteLocation), TABLES.SpecimenTest.OffsiteLocation);
		}

		[Test]
		public void GetPatientTestingWorklist_Date_Date_Fail()
		{
			DataTable dtTest = DAL.TestingWorklist.GetPatientTestingWorklist(this._invalidStart, this._invalidEnd);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetPatientTestingWorklist_Guid_Pass()
		{
			System.Guid unitGuid = System.Guid.NewGuid();
			
			DataTable dtTest = DAL.TestingWorklist.GetPatientTestingWorklist(unitGuid);
			
			Assert.AreEqual(40, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.TestingWorklistReportType), ARTIFICIAL.TestingWorklistReportType);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientGuid), TABLES.Patient.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientSpecimenGuid), TABLES.PatientSpecimen.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.TestGuid), ARTIFICIAL.TestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.TestUnitId), ARTIFICIAL.TestUnitId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ExceptionTransfusion.UnitId), TABLES.ExceptionTransfusion.UnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientLocation), TABLES.PatientTreatment.PatientLocation);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenAccessionNumber), TABLES.PatientSpecimen.SpecimenAccessionNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenCollectionDate), TABLES.PatientSpecimen.SpecimenCollectionDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.OrderableTestId), TABLES.BloodTestType.OrderableTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestText), TABLES.OrderableTest.OrderableTestText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestName), TABLES.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestingMethodCode), TABLES.SpecimenTest.TestingMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.TestingMethodText), TABLES.TestingMethod.TestingMethodText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackName), TABLES.Rack.RackName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.TestedWith), TABLES.BloodTestType.TestedWith);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.BloodTestTypeId), TABLES.SpecimenTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.Phase), TABLES.BloodTestType.Phase);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.SortColumn), TABLES.BloodTestType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestResultId), TABLES.SpecimenTest.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeName), TABLES.AntibodyType.AntibodyTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.TestTechId), TABLES.RackTest.TestTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.WorklistDate), ARTIFICIAL.WorklistDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestDate), TABLES.SpecimenTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestComments), TABLES.SpecimenTest.TestComments);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.AutoInstrumentName), TABLES.SpecimenTest.AutoInstrumentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.RecordStatusCode), TABLES.SpecimenTest.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.LastUpdateUser), TABLES.SpecimenTest.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.LastUpdateDate), TABLES.SpecimenTest.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.InactivateUser), TABLES.SpecimenTest.InactivateUser);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.InactivateDate), TABLES.SpecimenTest.InactivateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentText), TABLES.CannedComment.CannedCommentText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.CorrectedResultIndicator), TABLES.SpecimenTest.CorrectedResultIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.OffsiteIndicator), TABLES.SpecimenTest.OffsiteIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.OffsiteLocation), TABLES.SpecimenTest.OffsiteLocation);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetPatientTestingWorklist_Guid_Fail()
		{
			DataTable dtTest = DAL.TestingWorklist.GetPatientTestingWorklist(System.Guid.Empty);
		}

		[Test]
		public void GetBloodUnitTestingWorklist_Pass()
		{
			DataTable dtTest = DAL.TestingWorklist.GetBloodUnitTestingWorklist(this._startDate, this._endDate);

			Assert.AreEqual(31, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.TestingWorklistReportType), ARTIFICIAL.TestingWorklistReportType);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitGuid), TABLES.BloodUnitTest.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitTestGuid), TABLES.BloodUnitTest.BloodUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.BloodUnitTestId), ARTIFICIAL.BloodUnitTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestId), TABLES.OrderableTest.OrderableTestId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestName), TABLES.OrderableTest.OrderableTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestingMethodCode), TABLES.BloodUnitTest.TestingMethodCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.TestingMethodText), TABLES.TestingMethod.TestingMethodText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackName), TABLES.Rack.RackName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.TestedWith), TABLES.BloodTestType.TestedWith);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestTypeId), TABLES.BloodTestType.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestName), TABLES.BloodTestType.BloodTestName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.SortColumn), TABLES.BloodTestType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.Phase), TABLES.BloodTestType.Phase);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestResultId), TABLES.BloodUnitTest.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestTechId), TABLES.BloodUnitTest.TestTechId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestTechId), TABLES.BloodUnitTest.TestTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestDate), TABLES.BloodUnitTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.WorklistDate), ARTIFICIAL.WorklistDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestComments), TABLES.BloodUnitTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.AutoInstrumentName), TABLES.BloodUnitTest.AutoInstrumentName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RecordStatusCode), TABLES.BloodUnitTest.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.LastUpdateUser), TABLES.BloodUnitTest.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.LastUpdateDate), TABLES.BloodUnitTest.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.InactivateUser), TABLES.BloodUnitTest.InactivateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.InactivateDate), TABLES.BloodUnitTest.InactivateDate);
		}

		[Test]
		public void GetBloodUnitTestingWorklist_Fail()
		{
			DataTable dtTest = DAL.TestingWorklist.GetBloodUnitTestingWorklist(this._invalidStart, this._invalidEnd);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetRackQCTestingWorklist_Pass()
		{
			DataTable dtTest = DAL.TestingWorklist.GetRackQCTestingWorklist(this._startDate, this._endDate);
			DataTable dtTest2 = DAL.TestingWorklist.GetRackQCTestingWorklist(this._endDate, this._startDate);

			Assert.AreEqual(dtTest2.Rows.Count,  dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(27, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.TestingWorklistReportType), ARTIFICIAL.TestingWorklistReportType);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestGuid), TABLES.RackTest.RackTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.RackLotGuid), TABLES.RackLot.RackLotGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentGuid), TABLES.Reagent.ReagentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentTypeId), TABLES.Reagent.ReagentTypeId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.SortColumn), TABLES.ReagentType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotNumber), TABLES.Reagent.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestingMethodCode), TABLES.RackLot.TestingMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.TestingMethodText), TABLES.TestingMethod.TestingMethodText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackName), TABLES.Rack.RackName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithId), TABLES.RackLot.TestWithId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithName), TABLES.RackLot.TestWithName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTestResultType.RackTestResultTypeCode), TABLES.RackTestResultType.RackTestResultTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTestResultType.SortColumn), TABLES.RackTestResultType.SortColumn);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTestResultType.RackTestResultTypeText), TABLES.RackTestResultType.RackTestResultTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestResult), TABLES.RackTest.RackTestResult);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.SatisfactoryResultIndicator), TABLES.RackLot.SatisfactoryResultIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserName), TABLES.VbecsUser.UserName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.LotUseDate), TABLES.RackLot.LotUseDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.TestDate), TABLES.RackTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.QcDate), ARTIFICIAL.QcDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.Comments), TABLES.RackLot.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RecordStatusCode), TABLES.RackTest.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.LastUpdateUser), TABLES.RackTest.LastUpdateUser);

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.InvalidateUserName), ARTIFICIAL.InvalidateUserName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.LastUpdateDate), TABLES.RackTest.LastUpdateDate);
		}

		[Test]
		public void GetRackQCTestingWorklist_Fail()
		{
			DataTable dtTest = DAL.TestingWorklist.GetRackQCTestingWorklist(this._invalidStart, this._invalidEnd);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetReagentQCTestingWorklist_Pass()
		{
			DataTable dtTest = DAL.TestingWorklist.GetReagentQCTestingWorklist(this._startDate, this._endDate);
			DataTable dtTest2 = DAL.TestingWorklist.GetReagentQCTestingWorklist(this._endDate, this._startDate);

			Assert.AreEqual(dtTest2.Rows.Count,  dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(28, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.TestingWorklistReportType), ARTIFICIAL.TestingWorklistReportType);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestGuid), TABLES.RackTest.RackTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.RackLotGuid), TABLES.RackLot.RackLotGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentGuid), TABLES.Reagent.ReagentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentTypeId), TABLES.Reagent.ReagentTypeId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.SortColumn), TABLES.ReagentType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ControlCellId), TABLES.RackLot.ControlCellId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotNumber), TABLES.Reagent.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.TestingMethod), ARTIFICIAL.TestingMethod);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackName), TABLES.Rack.RackName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithId), TABLES.RackLot.TestWithId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithName), TABLES.RackLot.TestWithName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTestResultType.RackTestResultTypeCode), TABLES.RackTestResultType.RackTestResultTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTestResultType.SortColumn), TABLES.RackTestResultType.SortColumn);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTestResultType.RackTestResultTypeText), TABLES.RackTestResultType.RackTestResultTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RackTestResult), TABLES.RackTest.RackTestResult); 
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.SatisfactoryResultIndicator), TABLES.RackLot.SatisfactoryResultIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsUser.UserName), TABLES.VbecsUser.UserName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.TestDate), TABLES.RackTest.TestDate);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.Comments), TABLES.RackLot.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.RecordStatusCode), TABLES.RackTest.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.LastUpdateUser), TABLES.RackTest.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.InvalidateUserName), ARTIFICIAL.InvalidateUserName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackTest.LastUpdateDate), TABLES.RackTest.LastUpdateDate);			
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.AutoInstrumentName), TABLES.OrderedTest.AutoInstrumentName);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.CancellationText), TABLES.OrderedTest.CancellationText);			
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.WorklistDate), ARTIFICIAL.WorklistDate);
		}

		[Test]
		public void GetReagentQCTestingWorklist_Fail()
		{
			DataTable dtTest = DAL.TestingWorklist.GetReagentQCTestingWorklist(this._invalidStart, this._invalidEnd);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}
	}
}
#endif
